<?php
ini_set('display_errors', '0');
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Http\UploadedFile;
use Firebase\JWT\JWT;

require 'vendor/autoload.php';
include 'dbconfig.php';

$app = new \Slim\App ([
  'settings' => [
      'displayErrorDetails' => true
  ]
]);

//Middleware validates token (including expiration) for every call to the routes
$app->add ( new \Slim\Middleware\JwtAuthentication ( [ 
		//Omitting authorization for login route
		"passthrough" => [ 
				"/login" 
		],
		//Protected routes
		"path" => [ 
				"/" 
		],
		//Token secret key (Highly recommended to store it outside the code)
		"secret" => $secret_v 
] ) );

$app->options('/{routes:.+}', function ($request, $response, $args) {
    return $response;
});

$app->add(function ($req, $res, $next) {
    $response = $next($req, $res);
    return $response
            ->withHeader('Access-Control-Allow-Origin', '*')
            ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization')
            ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});


$app->post ( '/login', function (Request $request, Response $response) {

	global $conn,$secret_v;
	$jsonData = $request->getBody();
	$input = json_decode($jsonData);
	$username = $input->username;
	$password = $input->password;
	$password = md5($password);

	if ($username != null && $password != null) {
		
		//Looking for an user match from the db
		$sql="SELECT * FROM `user` WHERE `username`='$username' and `password`='$password'";
		$rs=$conn->query($sql);
		 
		if($rs->num_rows > 0) {

		  	$time = time ();
			$key = $secret_v;
			$row = $rs->fetch_assoc();
			$token = array (
					'iat' => $time, // Time when token was created
					'exp' => $time + (120 * 60), // Expiration time (+2 hour)
					'data' => [  // Aditional data
							'username' => $row['username']
					] 
			);

		  	//$data = JWT::decode($jwt, $key, array('HS256'));
			$jwt = JWT::encode ( $token, $key );
			$data["token"] = $jwt;
			$data["expires"] = $time + (60 * 60);
			
			return $response->withStatus(200)
		        ->withHeader("Content-Type", "application/json")
		        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

		} else {
		  	$data = ["status" => 0, 'msg' => "Incorrect login credentials"];
	    	return $response->withStatus(200)
		        ->withHeader("Content-Type", "application/json")
		        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
		}

	} else {
		$data = ["status" => 0, 'msg' => "Enter your login credentials"];
    	return $response->withStatus(200)
	        ->withHeader("Content-Type", "application/json")
	        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
	}
	
} );


$app->get ( '/customerinfo/{rsa_pin}', function (Request $request, Response $response) {

	global $conn;
	$rsa_pin = $request->getAttribute('rsa_pin');
	$sql = "SELECT * FROM `rsa_data_summary` where `P_I_N`='$rsa_pin'";
	$rs=$conn->query($sql);
	
	$arr = array();
	while($r = $rs->fetch_assoc()) {
	    $arr[] = $r;
	}
	
    foreach ($arr as $k1 => $v1) {
        $r1 = [];
        $i=0;
        foreach ($v1 as $k2 => $v2) {
            if ($i>=18 && $i<=23 && $i!=19){
                $r1[$k2] = "₦ ".number_format($v2,2);
            }else{
                $r1[$k2] = $v2;
            }
            $i = $i+1;
        }
        $arr[$k1] = $r1;
    }
	
	
	
	
	$data = ['result' => $arr];
	
	return $response->withStatus(200)
	    ->withHeader("Content-Type", "application/json")
	    ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

} );


$app->get ( '/customersearch[/{name}/{pin}/{dob}]', function (Request $request, Response $response) {
  
  global $conn;

  $name = $request->getAttribute('name');
  $pin = $request->getAttribute('pin');
  $dob = $request->getAttribute('dob');
  
  $sql = "SELECT * FROM `rsa_data_summary`";
  $counter = 0;
  
  if ($name != "nil"){
      if ($counter == 0){
          $sql = $sql." WHERE `Title_Name` LIKE '%".$name."%'";
      }else{
          $sql = $sql." AND `Title_Name` LIKE '%".$name."%'"; 
      }
      $counter = $counter+1;
  }
  
  if ($pin != "nil"){
      if ($counter == 0){
          $sql = $sql." WHERE `P_I_N` LIKE '%".$pin."%'";
      }else{
          $sql = $sql." AND `P_I_N` LIKE '%".$pin."%'"; 
      }
      $counter = $counter+1;
  }
  
  if ($dob != "nil"){
      if ($counter == 0){
          $sql = $sql." WHERE `Date_of_Birth`= '$dob'";
      }else{
          $sql = $sql." AND `Date_of_Birth`= '$dob'"; 
      }
      $counter = $counter+1;
  }
  
  $rs=$conn->query($sql);
  
  $arr = array();
  while($r = $rs->fetch_assoc()) {
      $arr[] = $r;
  }
  
  $data = ['result' => $arr];
  
  return $response->withStatus(200)
	    ->withHeader("Content-Type", "application/json")
	    ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
} );

$app->get ( '/generaloverview', function (Request $request, Response $response) {
    
    global $conn;
    $sql="SELECT COUNT(*) AS `total_no_of_account`, SUM(`Current_Total_Contributions`) AS `current_total_contributions`, SUM(`Current_Total_Withdrawals`) AS `current_total_withdrawals` FROM `rsa_data_summary`";
    $result = $conn->query($sql);
    $row=$result->fetch_array();
    
    $total_no_of_account = $row["total_no_of_account"]*1;
    $current_total_contributions = $row["current_total_contributions"]*1;
    $current_total_withdrawals = $row["current_total_withdrawals"]*-1;
    
    
    //get totals of different funds
    //Fund 1 => 100
    //Fund 2 => 1
    //Fund 3 => 300
    //Fund 4 => 11
    
    //Fund 1
    $sqlf1="SELECT * FROM `investment` WHERE `Fund_Code`=100 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $resultf1 = $conn->query($sqlf1);
    $rowf1=$resultf1->fetch_array();
    
    $GrossAssetValue_f1 = $rowf1["GrossAssetValue"];
    $OpeningNAV_f1 = $rowf1["OpeningNAV"];
    $ClosingNAV_f1 = $rowf1["ClosingNAV"];
    $OpeningBal_f1 = $rowf1["OpeningBal"];
    $CashBalance_f1 = $rowf1["CashBalance"];
    $MMBanksValue_f1 = $rowf1["MMBanksValue"];
    $UnitValue_f1 = $rowf1["UnitValue"];
    
    //Fund 2
    $sqlf2="SELECT * FROM `investment` WHERE `Fund_Code`=1 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $resultf2 = $conn->query($sqlf2);
    $rowf2=$resultf2->fetch_array();
    
    $GrossAssetValue_f2 = $rowf2["GrossAssetValue"];
    $OpeningNAV_f2 = $rowf2["OpeningNAV"];
    $ClosingNAV_f2 = $rowf2["ClosingNAV"];
    $OpeningBal_f2 = $rowf2["OpeningBal"];
    $CashBalance_f2 = $rowf2["CashBalance"];
    $MMBanksValue_f2 = $rowf2["MMBanksValue"];
    $UnitValue_f2 = $rowf2["UnitValue"];
    
    //Fund 3
    $sqlf3="SELECT * FROM `investment` WHERE `Fund_Code`=300 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $resultf3 = $conn->query($sqlf3);
    $rowf3=$resultf3->fetch_array();
    
    $GrossAssetValue_f3 = $rowf3["GrossAssetValue"];
    $OpeningNAV_f3 = $rowf3["OpeningNAV"];
    $ClosingNAV_f3 = $rowf3["ClosingNAV"];
    $OpeningBal_f3 = $rowf3["OpeningBal"];
    $CashBalance_f3 = $rowf3["CashBalance"];
    $MMBanksValue_f3 = $rowf3["MMBanksValue"];
    $UnitValue_f3 = $rowf3["UnitValue"];
    
    //Fund 4
    $sqlf4="SELECT * FROM `investment` WHERE `Fund_Code`=11 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $resultf4 = $conn->query($sqlf4);
    $rowf4=$resultf4->fetch_array();
    
    $GrossAssetValue_f4 = $rowf4["GrossAssetValue"];
    $OpeningNAV_f4 = $rowf4["OpeningNAV"];
    $ClosingNAV_f4 = $rowf4["ClosingNAV"];
    $OpeningBal_f4 = $rowf4["OpeningBal"];
    $CashBalance_f4 = $rowf4["CashBalance"];
    $MMBanksValue_f4 = $rowf4["MMBanksValue"];
    $UnitValue_f4 = $rowf4["UnitValue"];
    
    
    $GrossAssetValue = $GrossAssetValue_f1+$GrossAssetValue_f2+$GrossAssetValue_f3+$GrossAssetValue_f4;
    $OpeningNAV = $OpeningNAV_f1+$OpeningNAV_f2+$OpeningNAV_f3+$OpeningNAV_f4;
    $ClosingNAV = $ClosingNAV_f1+$ClosingNAV_f2+$ClosingNAV_f3+$ClosingNAV_f4;
    $OpeningBal = $OpeningBal_f1+$OpeningBal_f2+$OpeningBal_f3+$OpeningBal_f4;
    $CashBalance = $CashBalance_f1+$CashBalance_f2+$CashBalance_f3+$CashBalance_f4;
    $MMBanksValue = $MMBanksValue_f1+$MMBanksValue_f2+$MMBanksValue_f3+$MMBanksValue_f4;
    $UnitValue = $UnitValue_f1+$UnitValue_f2+$UnitValue_f3+$UnitValue_f4;
    
    
    
    $data = ["total_no_of_account" => number_format($total_no_of_account,2), "current_total_contributions" => "₦ ".number_format($current_total_contributions,2), "current_total_withdrawals" => "₦ ".number_format($current_total_withdrawals,2), "GrossAssetValue" => "₦ ".number_format($GrossAssetValue,2), "OpeningNAV" => "₦ ".number_format($OpeningNAV,2), "ClosingNAV" => "₦ ".number_format($ClosingNAV,2), "OpeningBal" => "₦ ".number_format($OpeningBal,2), "CashBalance" => "₦ ".number_format($CashBalance,2), "MMBanksValue" => "₦ ".number_format($MMBanksValue,2), "UnitValue" => number_format($UnitValue,2)];


  return $response->withStatus(200)
      ->withHeader("Content-Type", "application/json")
      ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

} );

$app->get ( '/investments', function (Request $request, Response $response) {
    
    global $conn;
    //get totals of different funds
    //Fund 1 => 100
    //Fund 2 => 1
    //Fund 3 => 300
    //Fund 4 => 11
    
    //Fund 1
    $sqlf1="SELECT * FROM `investment` WHERE `Fund_Code`=100 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $rs1=$conn->query($sqlf1);
	$arr1 = array();
	while($r1 = $rs1->fetch_assoc()) {
	    $arr1[] = $r1;
	}
	
    foreach ($arr1 as $k1 => $v1) {
        $r1 = [];
        $i=0;
        foreach ($v1 as $k2 => $v2) {
            if (($i>=3 && $i<=23) || $i==26 || $i==27 || $i==28 || $i==31 || $i==32){
                $r1[$k2] = "₦ ".number_format($v2,2);
            }else{
                $r1[$k2] = $v2;
            }
            $i = $i+1;
        }
        $arr1[$k1] = $r1;
    }
	
	//Fund 2
    $sqlf2="SELECT * FROM `investment` WHERE `Fund_Code`=1 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $rs2=$conn->query($sqlf2);
	$arr2 = array();
	while($r2 = $rs2->fetch_assoc()) {
	    $arr2[] = $r2;
	}
	
	foreach ($arr2 as $k1 => $v1) {
        $r1 = [];
        $i=0;
        foreach ($v1 as $k2 => $v2) {
            if (($i>=3 && $i<=23) || $i==26 || $i==27 || $i==28 || $i==31 || $i==32){
                $r1[$k2] = "₦ ".number_format($v2,2);
            }else{
                $r1[$k2] = $v2;
            }
            $i = $i+1;
        }
        $arr2[$k1] = $r1;
    }
	
	//Fund 3
    $sqlf3="SELECT * FROM `investment` WHERE `Fund_Code`=300 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $rs3=$conn->query($sqlf3);
	$arr3 = array();
	while($r3 = $rs3->fetch_assoc()) {
	    $arr3[] = $r3;
	}
	
	foreach ($arr3 as $k1 => $v1) {
        $r1 = [];
        $i=0;
        foreach ($v1 as $k2 => $v2) {
            if (($i>=3 && $i<=23) || $i==26 || $i==27 || $i==28 || $i==31 || $i==32){
                $r1[$k2] = "₦ ".number_format($v2,2);
            }else{
                $r1[$k2] = $v2;
            }
            $i = $i+1;
        }
        $arr3[$k1] = $r1;
    }
	
	//Fund 4
    $sqlf4="SELECT * FROM `investment` WHERE `Fund_Code`=11 ORDER BY `Valuation_Date` DESC LIMIT 1";
    $rs4=$conn->query($sqlf4);
	$arr4 = array();
	while($r4 = $rs4->fetch_assoc()) {
	    $arr4[] = $r4;
	}
	
	foreach ($arr4 as $k1 => $v1) {
        $r1 = [];
        $i=0;
        foreach ($v1 as $k2 => $v2) {
            if (($i>=3 && $i<=23) || $i==26 || $i==27 || $i==28 || $i==31 || $i==32){
                $r1[$k2] = "₦ ".number_format($v2,2);
            }else{
                $r1[$k2] = $v2;
            }
            $i = $i+1;
        }
        $arr4[$k1] = $r1;
    }
    
    
    //chart data
    $sqldx="SELECT * FROM `investment` ORDER BY `investment`.`Valuation_Date` DESC LIMIT 4";
    $rsdx=$conn->query($sqldx);
	$arrdx = array();
	$f1dx = array();
	$f2dx = array();
	$f3dx = array();
	$f4dx = array();
	while($rdx = $rsdx->fetch_assoc()) {
	    if($rdx['Fund_Code']==100){
	        $f1dx = $rdx;
	    }
	    
	    if($rdx['Fund_Code']==1){
	        $f2dx = $rdx;
	    }
	    
	    if($rdx['Fund_Code']==300){
	        $f3dx = $rdx;
	    }
	    
	    if($rdx['Fund_Code']==11){
	        $f4dx = $rdx;
	    }
	}
	
	$arrdx = [$f1dx,$f2dx,$f3dx,$f4dx];
    
    $data = ['fund1' => $arr1, 'fund2' => $arr2, 'fund3' => $arr3, 'fund4' => $arr4, 'chartdata' => $arrdx];


  return $response->withStatus(200)
      ->withHeader("Content-Type", "application/json")
      ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

} );

$app->get ( '/stateview', function (Request $request, Response $response) {
    
    global $conn;
    
    //getting data for the list
    $sql="SELECT COUNT(Correspondence_State_Code) AS `total_no_of_account`, SUM(Current_Total_Contributions) AS `total_contribution`, SUM(Current_Total_Withdrawals) * -1 AS `total_withdrawal`, `Correspondence_State_Code` AS `state_code`, CONCAT(UCASE(SUBSTRING(`State_Of_Posting_Name`, 1, 1)), LOWER(SUBSTRING(`State_Of_Posting_Name`, 2))) AS `state_name` FROM `rsa_data_summary` WHERE `Correspondence_State_Code` <> '' GROUP BY `Correspondence_State_Code` ASC";
    $result = $conn->query($sql);
    $arr = array();
    while($row = $result->fetch_assoc()) {
	    $arr[] = $row;
	}
    
    
    //getting data for graph
    //no of account
    $sql1="SELECT COUNT(Correspondence_State_Code) AS `total_no_of_account`, `Correspondence_State_Code` AS `state_code`, CONCAT(UCASE(SUBSTRING(`State_Of_Posting_Name`, 1, 1)), LOWER(SUBSTRING(`State_Of_Posting_Name`, 2))) AS `state_name` FROM `rsa_data_summary` WHERE `Correspondence_State_Code` <> '' GROUP BY `Correspondence_State_Code` ASC ORDER BY `total_no_of_account` DESC";
    $result1 = $conn->query($sql1);
    $arr_state1 = array();
    $arr_total_no_of_account1 = array();
    while($row1 = $result1->fetch_assoc()) {
        array_push($arr_state1,$row1['state_name']);
        array_push($arr_total_no_of_account1,$row1['total_no_of_account']);
	}
    
    //total contribution
    $sql2="SELECT SUM(Current_Total_Contributions) AS `total_contribution`, `Correspondence_State_Code` AS `state_code`, CONCAT(UCASE(SUBSTRING(`State_Of_Posting_Name`, 1, 1)), LOWER(SUBSTRING(`State_Of_Posting_Name`, 2))) AS `state_name` FROM `rsa_data_summary` WHERE `Correspondence_State_Code` <> '' GROUP BY `Correspondence_State_Code` ASC ORDER BY `total_contribution` DESC";
    $result2 = $conn->query($sql2);
    $arr_state2 = array();
    $arr_total_contribution2 = array();
    while($row2 = $result2->fetch_assoc()) {
        array_push($arr_state2,$row2['state_name']);
        array_push($arr_total_contribution2,$row2['total_contribution']);
	}
    
    
    $sql3="SELECT SUM(Current_Total_Withdrawals) * -1 AS `total_withdrawal`, `Correspondence_State_Code` AS `state_code`, CONCAT(UCASE(SUBSTRING(`State_Of_Posting_Name`, 1, 1)), LOWER(SUBSTRING(`State_Of_Posting_Name`, 2))) AS `state_name` FROM `rsa_data_summary` WHERE `Correspondence_State_Code` <> '' GROUP BY `Correspondence_State_Code` ASC ORDER BY `total_withdrawal` DESC";
    $result3 = $conn->query($sql3);
    $arr_state3 = array();
    $arr_total_withdrawal3 = array();
    while($row3 = $result3->fetch_assoc()) {
        array_push($arr_state3,$row3['state_name']);
        array_push($arr_total_withdrawal3,$row3['total_withdrawal']);
	}
	
	
	foreach ($arr as $k1 => $v1) {
        $r1 = [];
        $i=0;
        foreach ($v1 as $k2 => $v2) {
            if ($i==1 || $i==2){
                $r1[$k2] = "₦ ".number_format($v2,2);
            }elseif ($i==0){
                $r1[$k2] = number_format($v2);
            }else{
                $r1[$k2] = $v2;
            }
            $i = $i+1;
        }
        $arr[$k1] = $r1;
    }
    
    
    $data = ['result' => $arr, 'result2' =>[$arr_state1,$arr_total_no_of_account1,$arr_state2,$arr_total_contribution2,$arr_state3,$arr_total_withdrawal3]];


    return $response->withStatus(200)
      ->withHeader("Content-Type", "application/json")
      ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

} );

$app->run ();

?>