<?php
ini_set('display_errors', '0');
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Http\UploadedFile;
use Firebase\JWT\JWT;

require 'vendor/autoload.php';
include 'dbconfig.php';

$app = new \Slim\App ([
  'settings' => [
      'displayErrorDetails' => true
  ]
]);

//Middleware validates token (including expiration) for every call to the routes
$app->add ( new \Slim\Middleware\JwtAuthentication ( [ 
		//Omitting authorization for login route
		"passthrough" => [ 
				"/login" 
		],
		//Protected routes
		"path" => [ 
				"/" 
		],
		//Token secret key (Highly recommended to store it outside the code)
		"secret" => $secret_v 
] ) );

$app->options('/{routes:.+}', function ($request, $response, $args) {
    return $response;
});

$app->add(function ($req, $res, $next) {
    $response = $next($req, $res);
    return $response
            ->withHeader('Access-Control-Allow-Origin', '*')
            ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization')
            ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});


$app->post ( '/login', function (Request $request, Response $response) {

	global $secret_v;
	$jsonData = $request->getBody();
	$input = json_decode($jsonData);
	$username = $input->username;
	$password = $input->password;

	if ($username != null && $password != null) {
		 
		if($username == 'npfpl' && $password == 'npfpl_icui4cu' ) {

		  	$time = time ();
			$key = $secret_v;
			$token = array (
					'iat' => $time, // Time when token was created
					'exp' => $time + (120 * 60), // Expiration time (+2 hour)
					'data' => [  // Aditional data
							'username' => 'npfpl'
					] 
			);

		  	//$data = JWT::decode($jwt, $key, array('HS256'));
			$jwt = JWT::encode ( $token, $key );
			$data["token"] = $jwt;
			$data["expires"] = $time + (60 * 60);
			
			return $response->withStatus(200)
		        ->withHeader("Content-Type", "application/json")
		        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

		} else {
		  	$data = ["status" => 0, 'msg' => "Incorrect login credentials"];
	    	return $response->withStatus(200)
		        ->withHeader("Content-Type", "application/json")
		        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
		}

	} else {
		$data = ["status" => 0, 'msg' => "Enter your login credentials"];
    	return $response->withStatus(200)
	        ->withHeader("Content-Type", "application/json")
	        ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
	}
	
} );


$app->get ( '/showtables', function (Request $request, Response $response) {

	global $host,$username,$password,$database;
	
	mssql_connect($host, $username, $password);
    mssql_select_db($database);
    
	$sql = "show tables";
    $rs=mssql_query($sql);
    
    $arr = array();
	while($r = mssql_fetch_array($rs)) {
	    $arr[] = $r;
	}

	$data = ['result' => $arr];
	
	return $response->withStatus(200)
	    ->withHeader("Content-Type", "application/json")
	    ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

} );


$app->get ( '/gettabledata[/{tablename}/{limit}/{offset}]', function (Request $request, Response $response) {
  
    global $host,$username,$password,$database;
    
    $tablename = $request->getAttribute('tablename');
    $limit = $request->getAttribute('limit');
    $offset = $request->getAttribute('offset');
      
    mssql_connect($host, $username, $password);
    mssql_select_db($database);
      
    //$sql = "SELECT * FROM `$tablename` LIMIT $limit OFFSET $offset";
    $sql = "SELECT * FROM `$tablename` OFFSET $offset ROWS FETCH FIRST $limit ROWS ONLY";
    $rs=mssql_query($sql);
    
    $arr = array();
    while($r = mssql_fetch_array($rs)) {
        $arr[] = $r;
    }

	$data = ['result' => $arr];
  
    return $response->withStatus(200)
    	 ->withHeader("Content-Type", "application/json")
    	 ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
} );


$app->run ();

?>